return function(module, Transformation)

local transformRect = Transformation.transformRect

function Transformation:copy()
    return module.identity():concat(self)
end

function Transformation:inverse()
    return self:copy():invert()
end

function Transformation:transformRect(rect)
    return Rect:new(transformRect(self, rect))
end

function Transformation:isIdentity()
    local components = self:getComponents()
    return components[1] == 1 and components[2] == 0 and components[3] == 0 and components[4] == 1 and components[5] == 0 and components[6] == 0
end

function Transformation:toSVG()
    local tx, ty = self:transformPoint(0, 0)
    local x, y = self:transformPoint(1, 0)
    local scale = math.sqrt((x - tx) ^ 2 + (y - ty) ^ 2)
    local rotation = math.atan2(y - ty, x - tx) * 180 / math.pi
    local transforms = {}
    if tx ~= 0 or ty ~= 0 then
        transforms[#transforms + 1] = string.format('translate(%g, %g)', tx, ty)
    end
    if scale ~= 1 then
        transforms[#transforms + 1] = string.format('scale(%g)', scale)
    end
    if rotation ~= 0 then
        transforms[#transforms + 1] = string.format('rotate(%g)', rotation)
    end
    return table.concat(transforms, ' ')
end

end
